#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
    [TestFixture]
    public class BOL_WorkLoad : BaseTest 
    {
        private WorkLoad _workload;
        private DataTable _dtWorkload;
        private DataRow _drWorkload;
        //
        [SetUp]
        protected void SetUp() 
        {
			this.BaseSetUp();

            _dtWorkload = DAL.WorkLoad.GetVbecsWorkLoadForDivision(UnitTestConfig.TestDivisionCode);
			if (_dtWorkload.Rows.Count == 0)
			{
				//Create Workload
				Guid randomProcessGuid =  DataCreator.GetRandomRecordGuid(TABLES.VbecsProcess.TableName, "");
				DataRow drProcess = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM VbecsProcess WHERE VbecsProcessGuid = '" + randomProcessGuid.ToString() + "'");

				BOL.VbecsProcess tmpObj = new BOL.VbecsProcess(drProcess);
				DataRow drNewWorkload = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM WorkloadCache WHERE Code_Id > " + new Random().Next(1,199).ToString());

				tmpObj.AddItem(tmpObj.GetNewWorkLoad(drNewWorkload[TABLES.WorkloadCache.Lmip].ToString()));
				tmpObj.SaveChanges(Common.UpdateFunction.UnitTests);
			}
			_dtWorkload = DAL.WorkLoad.GetVbecsWorkLoadForDivision(UnitTestConfig.TestDivisionCode);
            _drWorkload = _dtWorkload.Rows[0];
            _workload = new BOL.WorkLoad(_drWorkload);
        }

        [Test]
                public void Ctor_DataRow_Pass()
        {
            Assert.IsNotNull(_workload);
        }

        [Test]
                [ExpectedExceptionAttribute(typeof(ArgumentException))]
        public void Ctor_DataRow_Fail()
        {
            _workload = new WorkLoad(new DataTable().NewRow());
        }

        [Test]
                public void Ctor_DataRow_Array_Pass()
        {
            //CPTCode_Text
            DataTable dt = new DataTable();
            dt.Columns.Add("CPTCode_Text");
            DataRow[] cptCodes = {dt.NewRow()};
            _workload = new WorkLoad(_drWorkload, cptCodes);
            Assert.IsTrue(_workload.IsValid);
        }

        [Test]
                [ExpectedExceptionAttribute(typeof(ArgumentException))]
        public void Ctor_DataRow_Array_Fail()
        {
            DataRow[] cptCodes = {new DataTable().NewRow()};
            _workload = new WorkLoad(new DataTable().NewRow(),cptCodes );
        }

        [Test]
                public void LoadDataRowFromThis_Pass()
        {
			DataRow dr = this._dtWorkload.NewRow();

			DataRow dr2 = this._workload.LoadDataRowFromThis(dr);

			Assert.AreEqual(dr, dr2, "DataRow");
        }

        [Test]
        [Ignore(StandardIgnoreReasons.NoFailureConditions)]
        public void LoadDataRowFromThis_Fail()
        {
        }

        [Test]
                public void VerifyMinColumnsInDataTable_Pass()
        {
            bool retval;
            string[] cols = BOL.WorkLoad.WORKLOAD_MINCOLUMNS.Split(',');
            retval = _workload.VerifyMinColumnsInDataTable(cols,_dtWorkload);
            Assert.AreEqual(retval, true);
        }

        [Test]
                public void VerifyMinColumnsInDataTable_Fail()
        {
            bool retval;

            string[] cols = ("TestColumn," + BOL.WorkLoad.WORKLOAD_MINCOLUMNS).Split(',');
            retval = _workload.VerifyMinColumnsInDataTable(cols,_dtWorkload);
            Assert.AreEqual(retval, false);
        }

        [Test]
                public void AssignedDate_Pass()
        {
            _workload.AssignedDate = DateTime.MaxValue;
            Assert.AreEqual(_workload.AssignedDate, DateTime.MaxValue);
			//replaced 'Today' with TZ changes, but this test doesn't make sense to me
			DateTime current = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
            _workload.AssignedDate = current;
            Assert.AreEqual(_workload.AssignedDate, current);
        }

        [Test]
        [ExpectedExceptionAttribute(typeof(ArgumentException))]
                public void AssignedDate_Fail()
        {
            _workload.AssignedDate = DateTime.MinValue;
        }

        [Test]
                public void UnAssignedDate_Pass()
        {
            _workload.UnAssignedDate = DateTime.MinValue;
            Assert.AreEqual(_workload.UnAssignedDate, DateTime.MinValue);
            _workload.UnAssignedDate = DateTime.MaxValue;
            Assert.AreEqual(_workload.UnAssignedDate, DateTime.MaxValue);
			//replaced 'Today' with TZ changes, but this test doesn't make sense to me
			DateTime current = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			_workload.UnAssignedDate = current;
            Assert.AreEqual(_workload.UnAssignedDate, current);
        }

        [Test]
        [ExpectedExceptionAttribute(typeof(ArgumentException))]
                public void UnAssignedDate_Fail()
        {
            _workload.AssignedDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
            _workload.UnAssignedDate =BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays(-1);
        }

        [Test]
                public void Cost_Pass()
        {
            Assert.IsNotNull(_workload.Cost);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Cost_Fail()
		{
		}

        [Test]
                public void LastUpdateDate_Pass()
        {
            Assert.IsNotNull(_workload.LastUpdateDate);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateDate_Fail()
		{
		}


        [Test]
                public void LastUpdateUser_Pass()
        {
            Assert.IsNotNull(_workload.LastUpdateUser);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void LastUpdateUser_Fail()
		{
		}


        [Test]
                public void CPTCodes_Pass()
        {
            Assert.IsNotNull(_workload.CPTCodes);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CPTCodes_Fail()
		{
		}

		[Test]
		public void WeightMultiplier_Pass()
		{
			byte tstValue = this._workload.WeightMultiplier;

			Assert.AreEqual(tstValue, this._workload.WeightMultiplier);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WeightMultiplier_Fail()
		{
		}


        [Test]
                public void DivisionCode_Pass()
        {
            Assert.IsNotNull(_workload.DivisionCode);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DivisionCode_Fail()
		{
		}

        [Test]
                public void WorkloadProcedure_Pass()
        {
            Assert.IsNotNull(_workload.WorkloadProcedure);
        }

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WorkloadProcedure_Fail()
		{
		}

        [Test]
                public void WorkloadCode_Pass()
        {
            Assert.IsNotNull(_workload.WorkloadCode);
        }

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WorkloadCode_Fail()
		{
		}

        [Test]
                public void WorkloadProcessGuid_Pass()
        {
            Assert.IsNotNull(_workload.WorkloadProcessGuid);
        }

		
		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WorkloadProcessGuid_Fail()
		{
		}

		[Test]
		public void GetAllVbecProcesses_Pass()
		{
			DataTable dt = DAL.WorkLoad.GetAllVbecsProcesses();
			Assert.IsNotNull(dt);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllVbecProcesses_Fail()
		{
		}


		[Test]
		public void RowVersion_Pass()
		{
			DataRow dtCurrentRow = this._dtWorkload.NewRow();

			foreach(DataRow dtRow in _dtWorkload.Rows)
			{
				if((System.Guid) dtRow[Common.VbecsTables.WorkloadProcess.WorkloadProcessGuid] == this._workload.WorkloadProcessGuid)
				{
					dtCurrentRow = dtRow;
					break;
				}
			}
						
			Assert.AreEqual((byte[]) dtCurrentRow[Common.VbecsTables.WorkloadProcess.RowVersion], this._workload.RowVersion);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void RecordStatusCode_Pass()
		{
			this._workload.RecordStatusCode = Common.RecordStatusCode.Active;
			Assert.AreEqual(this._workload.RecordStatusCode, Common.RecordStatusCode.Active);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RecordStatusCode_Fail()
		{
		}

		[Test]
		public void UpdateRecordStatusCode_Pass()
		{
			// This does not update the record status code.
			this._workload.UpdateRecordStatusCode(Common.RecordStatusCode.NationalStandard);
			
			Assert.IsTrue(true);

		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UpdateRecordStatusCode_Fail()
		{
		}

    }
}
#endif


